﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class OCBCHelperBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse GetItem(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            return OCBCHelperDB.GetItem(OCBCTransactionResponseID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse> GetList(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            return OCBCHelperDB.GetList(OCBCTransactionResponseID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            return OCBCHelperDB.GetDataTable(OCBCTransactionResponseID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            return OCBCHelperDB.GetDataSet(OCBCTransactionResponseID, ordersPaymentID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse myOrdersDetails)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                OCBCHelperDB.Save(myOrdersDetails);
                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
